<?php
/**
 * Upfate page content.
 *
 * @package C4WP
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="wrap features-wrap">
	<div class="c4wp-upgrade-section">
		
		<div class="content-block">
			<div class="logo-wrap">
				<img src="<?php echo esc_url( PPM_WP_URL . 'assets/images/password-policy-manager.png' ); ?>" alt="">
			</div>
			<p><?php esc_html_e( 'The security of your WordPress website & WooCommerce store is as strong as the weakest password!', 'c4wp-wpp' ); ?></p>
			<p><?php esc_html_e( 'Weak passwords should not jeopardize the security of your website. Configure strong password policies with WPassword and ensure your team, customers & subscribers use strong passwords.', 'c4wp-wpp' ); ?></p>
			<div class="premium-cta">
			<a href="https://www.melapress.com/wordpress-login-security/pricing/?utm_source=plugins&utm_medium=link&utm_campaign=mls" target="_blank" rel="noopener">Upgrade to Premium</a>
			</div>
		</div>

		<div class="content-block">
			<table class="c21 feature-table">
				<tbody>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10 c4"><span class="c5"></span></p>
						</td>
						<td class="c8 row-head" colspan="1" rowspan="1">
							<p class="c7"><span class="c5">Premium</span></p>
						</td>
						<td class="c12 row-head" colspan="1" rowspan="1">
							<p class="c7"><span class="c5">Free</span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Email support and forum access</strong>We stand behind all of our products with world-class support and a team of professionals who absolutely care.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Enforce Strong Passwords</strong>Easily enable password policies and enforce the use of strong passwords on your WordPress websites within seconds!</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Configurable Password Policies</strong>All the password policies are configurable. You can configure policies for password length, history, complexity, use of special characters and many others.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Password Policies per User Role</strong>Configure different password policies for different user roles, including custom ones. You can also exclude a specific user, or user role from all the policies..</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Multisite Network Compatible</strong>Enforce strong password policies at network level so no user jeopardizes the security of your multisite network.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>1-Click Reset All Passwords</strong>Reset all of the password and terminate all logged in sessions with just 1 click in case of suspicious activity. All users receive clear instructions on how reset their passwords, making this an easy process.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>WooCommerce & Third Party Plugins Ready</strong>Do you use WooCommerce for your eCommerce website? Do you use LearnDash, MemberPress and other popular plugins for Membership and business websites? Enforce login security policies on forms from these plugins with just a mouse click.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Hide the WordPress login page</strong>Change the URL of your WordPress login page so it is not accessible to malicious attackers.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Limit Login Attempts</strong>Automatically block users with too many failed login attempts to protect your website & users from successful password and dictionary attacks.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Restrict user login times</strong>Restrict your users' login times to specific days and hours and enforce your working hours policy, improve website and user account security, and reduce your website's attack surface.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Automatically Lock Inactive Users</strong>Inactive users are an easy prime target for malicious hackers. Our plugin automatically identifies & locks inactive users to help you protect your website. It also alerts you about them.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Configurable Email Templates</strong>Take control of all messages and their content with our easy to use email template settings.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Weekly summary email</strong>Get a weekly email with a detailed summary of all password resets and changes, inactivity lockouts, failed logins, and more.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
				</tbody>
			</table>
		</div>

		<div class="premium-cta">
			<a href="https://www.melapress.com/wordpress-login-security/pricing/?utm_source=plugins&utm_medium=link&utm_campaign=mls target="_blank" rel="noopener">Upgrade to Premium</a>
		</div>

	</div>
</div>

<style>
	#postbox-container-1 {
		display: none;
	}
	.features-wrap {
		background: #fff;
		padding: 25px 30px;
		max-width: 880px;
	}

	.features-wrap h2 {
		font-size: 28px;
			margin-bottom: 30px;
	}

	.features-wrap p {
		font-size: 14px;
		line-height: 28px;
		font-weight: normal;
	}

	.feature-list {
		margin-bottom: 20px;
	}

	.feature-list li {
		margin-bottom: 10px;
		font-size: 15px;
	}

	.feature-list li .dashicons {
		color:  #ff8977
	}

	.premium-cta {
		margin: 25px 0 15px;
		text-align: center;
	}

	.premium-cta .text-link {
		color:  #ff8977;
		background: transparent;
		border:  #ff8977;
		text-decoration: dashed;
	}

	.premium-cta a, .table-link {
		background-color:  #ff8977;
		color: #fff;
		padding: 15px 26px;
		border-radius: 30px;
		font-size: 16px;
		white-space: nowrap;
		text-decoration: none;
		font-weight: 700;
		display: inline-block;
		margin-right: 15px;
		border: 2px solid  #ff8977
	}

	.premium-cta a:hover, .table-link:hover, .premium-cta a.inverse, .table-link.inverse {
		color:  #ff8977;
		background-color: #fff;
	}

	.premium-cta a.inverse:hover {
		color: #fff;
		background-color:  #ff8977;
	}

	.content-block {
		margin-bottom: 26px;
		border-bottom: 1px solid #eee;
		padding-bottom: 15px;
		overflow: hidden;
	}

	.feature-table strong {
		font-size: 16px;
		clear: both;
		display: block;
	}
	
	.feature-table tr td {
		text-align: center;
		min-width: 200px
	}
	.feature-table tr td:first-of-type {
		text-align: left;
		font-weight: 500;
	}
	.feature-table td p {
		margin-top: 0;
	}
	.row-head span {
		font-size: 17px;
		font-weight: 700;
	}
	.feature-table .dashicons {
		color: #50284E;
	}
	.feature-table .dashicons-no {
		color: red;
	}
	.table-link {
		font-size: 14px;
		padding: 9px;
		width: 193px;
		margin-top: 10px;
	}
	.pull-up {
		position: relative;
		top: -23px;
	}

	.logo-wrap img {
		max-width: 230px;
		margin-top: 20px;
	}

	.logo-wrap {
		float: left;
		margin-right: 30px;
	}

</style>
