( function( $, undef ){

	// jQuery UI Widget constructor, that extends from wpColorPicker
	ColorPicker = {
		open: function() {
			var wrap = this.element.closest('.ct-iris-colorpicker-wrap');
			
			if(wrap.length)
				wrap.addClass('ct-iris-active');

			var oxygenControlRow = this.element.closest('.oxygen-control-row');

			if(oxygenControlRow.length > 0) {
				oxygenControlRow.css('z-index', 99);
				oxygenControlRow.css('position', 'relative');

			} else {
				this.element.closest('.oxygen-control').css('z-index', 99);
			}
			
			var sidebar = this.element.closest('.oxygen-sidebar-control-panel');
			if(sidebar.length > 0) {
				var sidebarWidth = sidebar.width(),
					sidebarOffset = sidebar.offset(),
					rightEnd = sidebarWidth + parseInt(sidebarOffset.left);

				var offset = this.element.parents('.oxygen-color-picker').find('.wp-picker-holder').offset(),
					farEnd = 202 + parseInt(offset.left);

				if( farEnd-rightEnd > 0) {
					this.element.parents('.oxygen-color-picker').find('.wp-picker-holder').css('left', (rightEnd-farEnd+30)+'px');
				} 
			}
		
			return this._super();
		},
		close: function() {

			var wrap = this.element.closest('.ct-iris-colorpicker-wrap');
			
			if(wrap.length)
				wrap.removeClass('ct-iris-active');

			var oxygenControlRow = this.element.closest('.oxygen-control-row');
			
			if(oxygenControlRow.length > 0) {
				oxygenControlRow.css('z-index', '');
				oxygenControlRow.css('position', '');
			} else {
				this.element.closest('.oxygen-control').css('z-index', '');
			}
			
			if(typeof(this.element.data('wpWpColorPicker')) === 'undefined' && typeof(this.element.data('ctCtColorPicker')) === 'undefined')
				return;

			this.element.parents('.oxygen-color-picker').find('.wp-picker-holder').css('left', '');

			return this._super();
		},
		
	};

	$.widget( 'ct.ctColorPicker', $.wp.wpColorPicker, ColorPicker );
}( jQuery ) );
